#include <screen/screen.h>
#include <stddef.h>
#include <stdlib.h>


void
set_display(screen_window_t screen_win, int display_id)
{
	if (display_id) {
		int i;
		int ndisplays = 0;
		int rc;
		screen_context_t screen_ctx = NULL;

		screen_get_window_property_pv(screen_win, SCREEN_PROPERTY_CONTEXT, (void **)&screen_ctx);

		rc = screen_get_context_property_iv(screen_ctx, SCREEN_PROPERTY_DISPLAY_COUNT, &ndisplays);
		if (rc) {
			perror("screen_get_context_property_iv(SCREEN_PROPERTY_DISPLAY_COUNT)");
			return;
		}
		fprintf(stderr, "no of display = %d\n",ndisplays);

		screen_display_t *screen_disp;
		screen_disp =(screen_display_t *) calloc(ndisplays, sizeof(*screen_disp));
		if (screen_disp == NULL) {
			fprintf(stderr, "could not allocate memory for display list\n");
			return;
		}

		rc = screen_get_context_property_pv(screen_ctx, SCREEN_PROPERTY_DISPLAYS, (void **)screen_disp);
		if (rc) {
			perror("screen_get_context_property_ptr(SCREEN_PROPERTY_DISPLAYS)");
			free(screen_disp);
			return;
		}

		int want_id = display_id;
		for (i = 0; i < ndisplays; ++i) {
			int actual_id = 0;  // invalid
			if((screen_get_display_property_iv(screen_disp[i], SCREEN_PROPERTY_ID, &actual_id)) == 0) {
			   if (want_id == actual_id) {
				   break;
			   }
            }
		}

		if (i >= ndisplays) {
			fprintf(stderr, "couldn't find display %d\n", display_id);
		} else {
			rc = screen_set_window_property_pv(screen_win, SCREEN_PROPERTY_DISPLAY, (void**)&screen_disp[i]);
            if (rc) {
                fprintf(stderr, "failed to set window display property\n");
                free(screen_disp);
			    return;
            }
		}
		free(screen_disp);
	}
}

